<?php
// Authentication component
?>
<div class="auth-card">
    <div class="auth-logo">
        <h1><?php echo APP_NAME; ?></h1>
        <p>Your Trusted Betting Platform</p>
    </div>

    <div class="auth-tabs">
        <button class="auth-tab active" data-auth="login">Login</button>
        <button class="auth-tab" data-auth="register">Register</button>
    </div>

    <form id="login-form" class="auth-form" onsubmit="return handleLogin(event)">
        <input type="hidden" name="csrf_token" value="<?php echo Security::generateCSRFToken(); ?>">
        <div class="form-group">
            <label for="login-phone">Phone Number</label>
            <input type="tel" id="login-phone" name="phone" placeholder="Enter your phone number" required>
        </div>
        <div class="form-group">
            <label for="login-password">Password</label>
            <input type="password" id="login-password" name="password" placeholder="Enter your password" required>
        </div>
        <div class="checkbox-group">
            <input type="checkbox" id="remember-me" name="remember">
            <label for="remember-me">রিমেম্বার মি</label>
        </div>
        <button type="submit" class="submit-btn">Login</button>
    </form>

    <form id="register-form" class="auth-form" style="display: none;" onsubmit="return handleRegister(event)">
        <input type="hidden" name="csrf_token" value="<?php echo Security::generateCSRFToken(); ?>">
        <div class="form-group">
            <label for="register-name">Full Name</label>
            <input type="text" id="register-name" name="name" placeholder="Enter your full name" required>
        </div>
        <div class="form-group">
            <label for="register-phone">Phone Number</label>
            <input type="tel" id="register-phone" name="phone" placeholder="Enter your phone number" required>
        </div>
        <div class="form-group">
            <label for="register-password">Password</label>
            <input type="password" id="register-password" name="password" placeholder="Enter your password" required>
        </div>
        <div class="form-group">
            <label for="register-confirm-password">Confirm Password</label>
            <input type="password" id="register-confirm-password" name="confirm_password" placeholder="Confirm your password" required>
        </div>
        <div class="form-group">
            <label for="referral-code-input">Referral Code (Optional)</label>
            <input type="text" id="referral-code-input" name="referral_code" placeholder="Enter referral code if you have one">
        </div>
        <button type="submit" class="submit-btn">Register</button>
    </form>
</div>